/*
The MIT License (MIT)

Copyright (c) 2015 Sune S. Nielsen, University of Luxembourg

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

package NkBenchSuite;

import java.util.Random;

/**
 * @author ssn
 * This class provides a simple example of using the NK IFP Benchmark suite
 */
public class Main
{
	private static Random random = new Random();
	
	/**
	 * Creates an individual solution by mutating from a parent
	 * @param parent
	 * @param mutationProbability
	 * @return new individual
	 */
	private static int[] makeIndividual(int[] parent, double mutationProbability)
	{
		int[] result = new int[parent.length];
		
		for (int i = 0; i < parent.length; i++)
		{
			if (random.nextDouble() <= mutationProbability)
			{
				result[i] = random.nextInt(20);
			}
			else
			{
				result[i] = parent[i];
			}
		}
		
		return result;
	}
	
	/**
	 * Runs basic accept first better experiment
	 * @param args
	 */
	public static void main(String[] args)
	{
		NkIfpBench testBench = new NkIfpBench(NkIfpBench.Instance.NkIfp1);
		//NkIfpBench testBench = new NkIfpBench(NkIfpBench.Instance.NkIfp2);
		
		int[] individual = new int[67];
		
		individual = makeIndividual(new int[67], 1.0); // start with a completely random individual		
		
		int[] bestIndividual = individual;
		double bestValue = Double.POSITIVE_INFINITY;
		
		int maxEvaluations = 1000000;
		
		System.out.println("Test start");
		long startTime = System.currentTimeMillis();
		
		for (int i = 0; i < maxEvaluations; i++)
		{	
			individual = makeIndividual(bestIndividual, 1.0 / 67.0);
			
			double value = testBench.evaluate(individual);
						
			if (value < bestValue)
			{
				bestValue = value;
				bestIndividual = individual;
				
				System.out.println("Eval:" + i + " best:" + bestValue);				
			}
		}
		
		long endTime = System.currentTimeMillis();
		
		System.out.println("Did " + maxEvaluations + " evaluation in " + (endTime - startTime) + "ms => " + (((double)(endTime - startTime)) / maxEvaluations) + "ms/eval" );
		System.out.println("Best value found:" + bestValue);		
		
	}

}
