/*
The MIT License (MIT)

Copyright (c) 2015 Sune S. Nielsen, University of Luxembourg

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

package NkBenchSuite;

import java.util.Random;

public class DefaultRandomGenerator extends AbstractRandomGenerator
{
	Random random;

	public DefaultRandomGenerator()
	{
		this.random = new Random();
	}
	
	@Override
	public void setSeed(long seed)
	{
		this.random.setSeed(seed);
	}

	@Override
	public double nextDouble()
	{
		return this.random.nextDouble();
	}
	
	@Override
	public double nextGaussian()
	{
		return this.random.nextGaussian();
	}

	@Override
	public int nextInt()
	{
		return this.random.nextInt();
	}

	@Override
	public int nextInt(int n)
	{
		return this.random.nextInt(n);
	}

	@Override
	public boolean nextBoolean()
	{
		return this.random.nextBoolean();
	}

}
