/*
The MIT License (MIT)

Copyright (c) 2015 Sune S. Nielsen, University of Luxembourg

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

package NkBenchSuite;

/**
 * @author ssn
 * Implements the (currently) two benchmark problems of the NK Landscape Protein IFP Benchmark Suite 
 */
public class NkIfpBench
{
	/**
	 * @author ssn
	 * enumerator for selecting instance
	 */
	public enum Instance
	{
		NkIfp1,
		NkIfp2,
	}
	
	private NklModel model1 = null; 
	private NklModel model2 = null;
	
	/**
	 * Constructor
	 * @param instance
	 */
	public NkIfpBench(Instance instance)
	{
		if (instance == Instance.NkIfp1)
		{
			this.model1 = new NklModel(67, 4, 20, NklModel.NeighbourhoodType.AdjacentNoCenter);
			this.model2 = new NklModel(67, 3, 20, NklModel.NeighbourhoodType.UniformRandom);
		}
		else if (instance == Instance.NkIfp2)
		{
			this.model1 = new NklModel(67, 4, 20, NklModel.NeighbourhoodType.AdjacentNoCenter);
			this.model2 = new NklModel(67, 5, 20, NklModel.NeighbourhoodType.TriangularAndUniformRandom);
		}
	}
	
	/**
	 * Evaluates the individual
	 * @param individual
	 * @return value to be minimised
	 */
	public double evaluate(int[] individual)
	{
		double nk1 = model1.evaluate(individual);
		double nk2 = model2.evaluate(individual);
					
		return -nk1 * nk2;	
	}
}
