/*
The MIT License (MIT)

Copyright (c) 2015 Sune S. Nielsen, University of Luxembourg

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

package NkBenchSuite;

public abstract class AbstractRandomGenerator
{
	public abstract void setSeed(long seed);
	public abstract double nextDouble();
	public abstract double nextGaussian();
	public abstract int nextInt();
	public abstract int nextInt(int n);
	public abstract boolean nextBoolean();
	
	public double nextDouble(double lower, double upper)
	{
		return lower + Math.abs(upper-lower) * nextDouble();
	}
	
	/**
	 * @param a lower
	 * @param b upper
	 * @param c center
	 * @return
	 */
	public double nextTriangle(double a, double b, double c)
	{
		//mean = (a+b+c) / 3
		double u = nextDouble();
		double fc = (c-a)/(b-a);
		if (u < fc)
		{
			return (a + Math.sqrt(u * (b - a) * (c - a)));
		}
		else
		{
			return (b - Math.sqrt((1 - u) * (b - a) * (b - c)));
		}
	}
	
	/**
	 * @param a1 lower1
	 * @param b1 upper1
	 * @param c1 center1
	 * @param a2 lower2
	 * @param b2 upper2
	 * @param c2 center2
	 * @return
	 */
	public double nextDualTriangle(double a1, double b1, double c1, double a2, double b2, double c2)
	{
		if (nextBoolean())
			return nextTriangle(a1, b1, c1);
		else
			return nextTriangle(a2, b2, c2);
	}

	public int[] intPermutation(int n)
	{
		int[] result = new int[n];
		
		for (int i = 0; i < n; i++)
		{
			int pos = nextInt(n);
			int latch1, latch2 = result[i]; 
			if (pos >= i)
			{
				latch1 = i;
			}
			else
			{
				latch1 = result[pos];
			}
			
			result[pos] = latch2;
			result[i] = latch1;
		}
		
		return result;
	}
}
